from django.shortcuts import render
from django.http import JsonResponse
from playwright.sync_api import sync_playwright
import datetime

# Show form
def deposit_form(request):
    return render(request, "deposit_form.html")


# # Handle deposit
# def submit_to_goexch9(request):
#     if request.method == "POST":
#         username = request.POST.get("username")
#         amount = request.POST.get("amount")
#         remark = f"Auto Deposit {datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')}"
#         txn_password = "92252"  # Should be secured, just demo

#         with sync_playwright() as p:
#             browser = p.chromium.launch(headless=False)
#             context = browser.new_context()
#             page = browser.new_page()

#             # Step 1: Go to admin login
#             page.goto("https://goexch9.com/admin", timeout=60000)

#             # if "/users" not in page.url:
#             # page.fill('input[name="username"]', "vicky87002")
#             # page.fill('input[name="password"]', "LoveMaa@1")
#             # page.click('button[type="submit"]')
#             # page.wait_for_load_state("networkidle")
#             # if "/users" not in page.url:
#             try:
#                 page.fill('input[name="username"]', "vicky87002")
#                 page.fill('input[name="password"]', "LoveMaa@1")
#                 page.click("form.form-horizontal[data-vv-scope='form-login'] >> button:has-text('Login')")
#                 page.wait_for_load_state("networkidle")
#             except Exception as e:
#                 print("Login failed or already logged in:", e)
#                 # print("Already logged in or on the user list page")
#             # else:
#             #     # Fill login form
#             #     page.fill('input[name="username"]', "vicky87002")
#             #     page.fill('input[name="password"]', "LoveMaa@1")
#             #     page.eval_on_selector(
#             #         "form.form-horizontal[data-vv-scope='form-login']",
#             #         "form => form.submit()"
#             #     )

#             # Submit the specific form
#             # page.eval_on_selector('form.form-horizontal[data-vv-scope="form-login"]', "form => form.submit()")

#             # Wait for the page to load after login
#             page.wait_for_load_state("networkidle")

#             # Step 2: Navigate to deposit form
#             page.goto("https://goexch9.com/admin/users")
#             page.wait_for_selector('input[type="search"]')

#             # # Step 3: Search user
#             page.fill('input[type="search"]', username)
#             page.click("text=Load")
#             page.wait_for_timeout(2000)  # wait for reload
#             # # Step 4: Click Deposit (D) button
#             # page.click("button:has-text('D')")  # assumes first matching "D"
#             page.locator("div.btn-group >> button").filter(has_text="D").click()

#             page.wait_for_selector('form[data-vv-scope="userdepositeMDL"]')

#             # # Fill the form fields
#             page.fill('input[name="userDipositeamount"]', str(amount))
#             page.fill('textarea[name="userDipositeremark"]', remark)
#             page.fill('input[name="userDipositempassword"]', txn_password)

#             # # Submit
#             # page.click('button[type="submit"]')
#             try:
#                 # page.eval_on_selector("form[data-vv-scope='userdepositeMDL']", "form => form.submit()")
#                 page.click("form[data-vv-scope='userdepositeMDL'] >> button:has-text(/submit/i)")

#                 print("Form submitted successfully")
#             except Exception as e:
#                 print("Error clicking submit button:", e)

#             page.wait_for_load_state("networkidle")

#             success = "Deposit Successful" in page.content()
#             browser.close()

#         return JsonResponse({"status": "success" if success else f"failed"})
from django.http import JsonResponse
import datetime
from playwright.sync_api import sync_playwright, TimeoutError

def submit_to_goexch9(request):
    if request.method != "POST":
        return JsonResponse({"status": "failed", "error": "Invalid request method"})

    username = request.POST.get("username")
    amount = request.POST.get("amount")
    remark = f"Auto Deposit {datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')}"
    txn_password = "92252"  # Should be secured in production

    with sync_playwright() as p:
        browser = p.chromium.launch(headless=True)
        context = browser.new_context()
        page = context.new_page()

        # Step 1: Login
        page.goto("https://goexch9.com/admin", timeout=60000)
        try:
            page.fill('input[name="username"]', "vicky87002")
            page.fill('input[name="password"]', "LoveMaa@1")
            page.wait_for_timeout(500)  # small delay for JS to bind inputs
            page.click("form.form-horizontal[data-vv-scope='form-login'] >> button:has-text('Login')")
            page.wait_for_load_state("networkidle", timeout=10000)
        except Exception as e:
            print("Login failed or already logged in:", e)

        # Step 2: Navigate to Users page
        page.goto("https://goexch9.com/admin/users")
        page.wait_for_selector('input[type="search"]', timeout=10000)

        # Step 3: Search user
        page.fill('input[type="search"]', username)
        page.click("text=Load")
        page.wait_for_timeout(2000)  # wait for search results to load

        # Step 4: Click Deposit "D" button
        try:
            page.locator("div.btn-group >> button", has_text="D").first.click()
            page.wait_for_selector('form[data-vv-scope="userdepositeMDL"]', timeout=10000)
        except TimeoutError:
            browser.close()
            return JsonResponse({"status": "failed", "error": "Deposit button/form not found"})

        # Step 5: Fill deposit form
        page.fill('input[name="userDipositeamount"]', str(amount))
        page.fill('textarea[name="userDipositeremark"]', remark)
        page.fill('input[name="userDipositempassword"]', txn_password)

        # Step 6: Submit deposit form
        try:
            page.locator("form[data-vv-scope='userdepositeMDL'] >> button").filter(has_text="submit").first.click()
            page.wait_for_load_state("networkidle")
            page.wait_for_selector("#swal2-content", timeout=10000)
            # Check for success message
            success_text = page.locator("#swal2-content").inner_text()
            # Optional: Wait/check for success message
            success_msg = "Sucessfull Balance Transfer" in success_text
            page.wait_for_load_state("networkidle")
            if success_msg:
                success = True
            else:
                success = False
        except Exception as e:
            print("Error submitting deposit form:", e)
            success = False

        browser.close()
        return JsonResponse({"status": "success" if success else "failed"})
